/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.emulator;

import java.util.Stack;
import org.eclipse.tm.internal.terminal.emulator.IVT100EmulatorBackend;
import org.eclipse.tm.internal.terminal.model.TerminalTextDataStore;
import org.eclipse.tm.terminal.model.ITerminalTextData;
import org.eclipse.tm.terminal.model.Style;

public class VT100EmulatorBackend
implements IVT100EmulatorBackend {
    private int fCursorColumn;
    private int fCursorLine;
    private Style fDefaultStyle;
    private Style fStyle;
    int fLines;
    int fColumns;
    private int fScrollingRegionTopLine;
    private int fScrollingRegionBottomLine;
    private Stack fBufferStack = new Stack();
    private boolean wrapNewLine = false;
    private final ITerminalTextData fTerminal;

    public VT100EmulatorBackend(ITerminalTextData terminal) {
        this.fTerminal = terminal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll() {
        ITerminalTextData iTerminalTextData = this.fTerminal;
        synchronized (iTerminalTextData) {
            int n = this.fTerminal.getHeight();
            int line = 0;
            while (line < n) {
                this.fTerminal.cleanLine(line);
                ++line;
            }
            this.fTerminal.setDimensions(this.fLines, this.fTerminal.getWidth());
            this.setStyle(this.getDefaultStyle());
            this.setCursor(0, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDimensions(int lines, int cols) {
        ITerminalTextData iTerminalTextData = this.fTerminal;
        synchronized (iTerminalTextData) {
            if (lines == this.fLines && cols == this.fColumns) {
                return;
            }
            int cl = lines - (this.fLines - this.getCursorLine());
            int cc = this.getCursorColumn();
            int newLines = Math.max(lines, this.fTerminal.getHeight());
            if (this.fTerminal.getHeight() == this.fLines) {
                if (lines < this.fLines) {
                    cl += this.fLines - lines;
                    newLines = lines;
                } else {
                    cl += this.fLines - lines;
                }
            }
            this.fLines = lines;
            this.fColumns = cols;
            this.setScrollingRegion(1, this.fLines);
            this.fTerminal.setDimensions(newLines, this.fColumns);
            this.setCursor(cl, cc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int toAbsoluteLine(int line) {
        ITerminalTextData iTerminalTextData = this.fTerminal;
        synchronized (iTerminalTextData) {
            return this.fTerminal.getHeight() - this.fLines + line;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertCharacters(int charactersToInsert) {
        ITerminalTextData iTerminalTextData = this.fTerminal;
        synchronized (iTerminalTextData) {
            int line = this.toAbsoluteLine(this.fCursorLine);
            int n = charactersToInsert;
            int col = this.fColumns - 1;
            while (col >= this.fCursorColumn + n) {
                char c = this.fTerminal.getChar(line, col - n);
                Style style = this.fTerminal.getStyle(line, col - n);
                this.fTerminal.setChar(line, col, c, style);
                --col;
            }
            int last = Math.min(this.fCursorColumn + n, this.fColumns);
            int col2 = this.fCursorColumn;
            while (col2 < last) {
                this.fTerminal.setChar(line, col2, '\u0000', null);
                ++col2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eraseToEndOfScreen() {
        ITerminalTextData iTerminalTextData = this.fTerminal;
        synchronized (iTerminalTextData) {
            this.eraseLineToEnd();
            int line = this.toAbsoluteLine(this.fCursorLine + 1);
            while (line < this.toAbsoluteLine(this.fLines)) {
                this.fTerminal.cleanLine(line);
                ++line;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eraseToCursor() {
        ITerminalTextData iTerminalTextData = this.fTerminal;
        synchronized (iTerminalTextData) {
            int line = this.toAbsoluteLine(0);
            while (line < this.toAbsoluteLine(this.fCursorLine)) {
                this.fTerminal.cleanLine(line);
                ++line;
            }
            this.eraseLineToCursor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eraseAll() {
        ITerminalTextData iTerminalTextData = this.fTerminal;
        synchronized (iTerminalTextData) {
            int line = this.toAbsoluteLine(0);
            while (line < this.toAbsoluteLine(this.fLines)) {
                this.fTerminal.cleanLine(line);
                ++line;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eraseLine() {
        ITerminalTextData iTerminalTextData = this.fTerminal;
        synchronized (iTerminalTextData) {
            this.fTerminal.cleanLine(this.toAbsoluteLine(this.fCursorLine));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eraseLineToEnd() {
        ITerminalTextData iTerminalTextData = this.fTerminal;
        synchronized (iTerminalTextData) {
            int line = this.toAbsoluteLine(this.fCursorLine);
            int col = this.fCursorColumn;
            while (col < this.fColumns) {
                this.fTerminal.setChar(line, col, '\u0000', null);
                ++col;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eraseLineToCursor() {
        ITerminalTextData iTerminalTextData = this.fTerminal;
        synchronized (iTerminalTextData) {
            int line = this.toAbsoluteLine(this.fCursorLine);
            int col = 0;
            while (col <= this.fCursorColumn) {
                this.fTerminal.setChar(line, col, '\u0000', null);
                ++col;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertLines(int n) {
        ITerminalTextData iTerminalTextData = this.fTerminal;
        synchronized (iTerminalTextData) {
            if (!this.isCusorInScrollingRegion()) {
                return;
            }
            assert (n > 0);
            int line = this.toAbsoluteLine(this.fCursorLine);
            int nLines = this.toAbsoluteLine(this.fScrollingRegionBottomLine) + 1 - line;
            this.fTerminal.scroll(line, nLines, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteCharacters(int n) {
        ITerminalTextData iTerminalTextData = this.fTerminal;
        synchronized (iTerminalTextData) {
            int first;
            int line = this.toAbsoluteLine(this.fCursorLine);
            int col = this.fCursorColumn + n;
            while (col < this.fColumns) {
                char c = this.fTerminal.getChar(line, col);
                Style style = this.fTerminal.getStyle(line, col);
                this.fTerminal.setChar(line, col - n, c, style);
                ++col;
            }
            int col2 = first = Math.max(this.fCursorColumn, this.fColumns - n);
            while (col2 < this.fColumns) {
                this.fTerminal.setChar(line, col2, '\u0000', null);
                ++col2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteLines(int n) {
        ITerminalTextData iTerminalTextData = this.fTerminal;
        synchronized (iTerminalTextData) {
            if (!this.isCusorInScrollingRegion()) {
                return;
            }
            assert (n > 0);
            int line = this.toAbsoluteLine(this.fCursorLine);
            int nLines = this.toAbsoluteLine(this.fScrollingRegionBottomLine) + 1 - line;
            this.fTerminal.scroll(line, nLines, -n);
        }
    }

    private boolean isCusorInScrollingRegion() {
        return this.fScrollingRegionTopLine <= this.fCursorLine && this.fCursorLine <= this.fScrollingRegionBottomLine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Style getDefaultStyle() {
        ITerminalTextData iTerminalTextData = this.fTerminal;
        synchronized (iTerminalTextData) {
            return this.fDefaultStyle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultStyle(Style defaultStyle) {
        ITerminalTextData iTerminalTextData = this.fTerminal;
        synchronized (iTerminalTextData) {
            this.fDefaultStyle = defaultStyle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Style getStyle() {
        ITerminalTextData iTerminalTextData = this.fTerminal;
        synchronized (iTerminalTextData) {
            if (this.fStyle == null) {
                return this.fDefaultStyle;
            }
            return this.fStyle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStyle(Style style) {
        ITerminalTextData iTerminalTextData = this.fTerminal;
        synchronized (iTerminalTextData) {
            this.fStyle = style;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendString(String buffer) {
        ITerminalTextData iTerminalTextData = this.fTerminal;
        synchronized (iTerminalTextData) {
            char[] chars = buffer.toCharArray();
            int i = 0;
            while (i < chars.length) {
                if (this.wrapNewLine) {
                    this.doNewline();
                }
                int line = this.toAbsoluteLine(this.fCursorLine);
                int n = Math.min(this.fColumns - this.fCursorColumn, chars.length - i);
                this.fTerminal.setChars(line, this.fCursorColumn, chars, i, n, this.fStyle);
                int col = this.fCursorColumn + n;
                i += n;
                if (col >= this.fColumns) {
                    this.setCursorColumn(0);
                    this.wrapNewLine = true;
                    continue;
                }
                this.setCursorColumn(col);
            }
        }
    }

    private void doNewline() {
        this.wrapNewLine = false;
        if (this.fCursorLine + 1 >= this.fLines) {
            int h = this.fTerminal.getHeight();
            this.fTerminal.addLine();
            if (h != this.fTerminal.getHeight()) {
                this.setCursorLine(this.fCursorLine + 1);
            }
        } else if (this.fScrollingRegionTopLine != 0 || this.fScrollingRegionBottomLine != this.fLines - 1) {
            this.fTerminal.scroll(this.toAbsoluteLine(this.fScrollingRegionTopLine), this.fScrollingRegionBottomLine - this.fScrollingRegionTopLine + 1, -1);
        } else {
            this.setCursorLine(this.fCursorLine + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processNewline() {
        ITerminalTextData iTerminalTextData = this.fTerminal;
        synchronized (iTerminalTextData) {
            this.doNewline();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCursorLine() {
        ITerminalTextData iTerminalTextData = this.fTerminal;
        synchronized (iTerminalTextData) {
            return this.fCursorLine;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCursorColumn() {
        ITerminalTextData iTerminalTextData = this.fTerminal;
        synchronized (iTerminalTextData) {
            return this.fCursorColumn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCursor(int targetLine, int targetColumn) {
        ITerminalTextData iTerminalTextData = this.fTerminal;
        synchronized (iTerminalTextData) {
            this.setCursorLine(targetLine);
            this.setCursorColumn(targetColumn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCursorColumn(int targetColumn) {
        ITerminalTextData iTerminalTextData = this.fTerminal;
        synchronized (iTerminalTextData) {
            this.wrapNewLine = false;
            if (targetColumn < 0) {
                targetColumn = 0;
            } else if (targetColumn >= this.fColumns) {
                targetColumn = this.fColumns - 1;
            }
            this.fCursorColumn = targetColumn;
            this.fTerminal.setCursorColumn(targetColumn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCursorLine(int targetLine) {
        ITerminalTextData iTerminalTextData = this.fTerminal;
        synchronized (iTerminalTextData) {
            this.wrapNewLine = false;
            if (targetLine < 0) {
                targetLine = 0;
            } else if (targetLine >= this.fLines) {
                targetLine = this.fLines - 1;
            }
            this.fCursorLine = targetLine;
            this.fTerminal.setCursorLine(this.toAbsoluteLine(targetLine));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLines() {
        ITerminalTextData iTerminalTextData = this.fTerminal;
        synchronized (iTerminalTextData) {
            return this.fLines;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getColumns() {
        ITerminalTextData iTerminalTextData = this.fTerminal;
        synchronized (iTerminalTextData) {
            return this.fColumns;
        }
    }

    public void setScrollingRegion(int topLine, int bottomLine) {
        this.fScrollingRegionTopLine = topLine - 1;
        this.fScrollingRegionBottomLine = bottomLine - 1;
    }

    public int getScrollingRegionBottomLine() {
        return this.fScrollingRegionBottomLine;
    }

    public int getScrollingRegionTopLine() {
        return this.fScrollingRegionTopLine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAlternativeScreenBuffer(boolean enable) {
        ITerminalTextData iTerminalTextData = this.fTerminal;
        synchronized (iTerminalTextData) {
            this.wrapNewLine = false;
            if (enable) {
                TerminalTextDataStore data = new TerminalTextDataStore();
                data.copy(this.fTerminal);
                this.fBufferStack.push(data);
            } else if (!this.fBufferStack.isEmpty()) {
                ITerminalTextData data = (ITerminalTextData)this.fBufferStack.pop();
                if (this.fTerminal.getWidth() != data.getWidth()) {
                    data.setDimensions(data.getHeight(), this.fTerminal.getWidth());
                }
                this.fTerminal.copy(data);
            }
        }
    }
}

